/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWCanCreateParameters;
import filenet.vw.api.IVWHasParameterDefs;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAssociationTargetType;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWJoinType;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSplitType;
import filenet.vw.api.VWStepPaletteDefinition;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXPDL_20_parser;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public final class VWStepDefinition
extends VWMapNode
implements Serializable,
IVWHasParameterDefs,
IVWCanCreateParameters,
Cloneable {
    private static final long serialVersionUID = 119072L;
    protected boolean canReassign = true;
    protected boolean canViewStatus = true;
    protected boolean canViewHistory = false;
    protected boolean ignoreInvalidUsers = false;
    protected String queueName = null;
    protected String operationName = null;
    protected String[] operationParameters = null;
    protected String requestedInterface;
    private VWParticipant[] participants = null;
    private String[] responses = null;
    private VWParameterDefinition[] parameters = null;
    private VWArrayHandler parametersHandler = new VWArrayHandler();
    private String deadline = null;
    private String deadlineMap = null;
    private long reminder = 0L;
    protected static final int VALUE_ARRAY_SIZE = 2;
    public static final int LVALUE = 0;
    public static final int RVALUE = 1;
    private String[][] preAssignments = null;
    private String[][] postAssignments = null;
    private String postMilestone = null;
    private String preMilestone = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2011-01-06 03:31:08 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/PUI_460_FP01_Int/1 $";
    }

    protected VWStepDefinition(VWMapDefinition theMap, String theName, int theStepId) throws VWException {
        super(theMap, theName, theStepId);
    }

    protected VWStepDefinition(VWMapDefinition theMap) {
        super(theMap);
    }

    protected VWStepDefinition(VWStepPaletteDefinition theStepPalette) {
        super(theStepPalette);
    }

    protected VWStepDefinition(int theStepId) {
        super(theStepId);
    }

    public VWParameterDefinition createParameter(String theName, int theMode, String theValue, int theType, boolean theIsArray) throws VWException {
        VWParameterDefinition newParameter = new VWParameterDefinition(this, theName, theMode, theValue, theType, theIsArray);
        this.parameters = (VWParameterDefinition[])this.parametersHandler.addElementToArray(this.parameters, newParameter);
        return newParameter;
    }

    public void deleteParameter(String theName) throws VWException {
        int index = this.parametersHandler.getIndexFromStringFieldValue(this.parameters, "name", theName);
        if (index == -1) {
            throw new VWException("vw.api.VWStepDefinitionParameterNotFound", "No parameter found with name equal to {0} in step definition.", theName);
        }
        this.parametersHandler.deleteElementFromArray(this.parameters, index);
    }

    public VWParameterDefinition getParameterDefinition(String theName) throws VWException {
        int index = this.parametersHandler.getIndexFromStringFieldValue(this.parameters, "name", theName);
        if (index == -1) {
            String authName = this.translateToAuthored(theName);
            if (authName != null && authName.compareTo(theName) != 0) {
                index = this.parametersHandler.getIndexFromStringFieldValue(this.parameters, "name", authName);
            }
            if (index == -1) {
                throw new VWException("vw.api.VWStepDefinitionParameterNotFound", "No parameter found with name equal to {0} in step definition.", theName);
            }
        }
        return this.parameters[index];
    }

    public VWParameterDefinition[] getParameterDefinitions() throws VWException {
        return (VWParameterDefinition[])this.parametersHandler.getElements(this.parameters);
    }

    public boolean getCanReassign() {
        return this.canReassign;
    }

    public void setCanReassign(boolean theFlag) {
        this.canReassign = theFlag;
    }

    public boolean getIgnoreInvalidUsers() {
        return this.ignoreInvalidUsers;
    }

    public void setIgnoreInvalidUsers(boolean theFlag) {
        this.ignoreInvalidUsers = theFlag;
    }

    public boolean getCanViewStatus() {
        return this.canViewStatus;
    }

    public void setCanViewStatus(boolean theFlag) {
        this.canViewStatus = theFlag;
    }

    public boolean getCanViewHistory() {
        return this.canViewHistory;
    }

    public void setCanViewHistory(boolean bFlag) {
        this.canViewHistory = bFlag;
    }

    public String toString() {
        return this.getName();
    }

    public VWParticipant[] getParticipants() {
        if (this.participants != null && this.participants.length > 0) {
            VWParticipant[] participantArray = new VWParticipant[this.participants.length];
            for (int i = 0; i < this.participants.length; ++i) {
                if (this.participants[i] == null) continue;
                participantArray[i] = (VWParticipant)this.participants[i].clone();
            }
            return participantArray;
        }
        return null;
    }

    public void setParticipants(VWParticipant[] theParticipants) {
        VWParticipant[] newParticipantArray = null;
        if (theParticipants != null && theParticipants.length > 0) {
            newParticipantArray = new VWParticipant[theParticipants.length];
            for (int i = 0; i < theParticipants.length; ++i) {
                if (theParticipants[i] == null) continue;
                newParticipantArray[i] = (VWParticipant)theParticipants[i].clone();
            }
        }
        this.participants = newParticipantArray;
    }

    public String getQueueName() {
        return this.translateStr(this.queueName);
    }

    public void setQueueName(String theName) {
        this.queueName = theName;
    }

    public String getOperationName() {
        return this.translateStr(this.operationName);
    }

    public void setOperationName(String theName) {
        this.operationName = theName;
    }

    public String[] getOperationParameters() {
        if (this.operationParameters != null && this.operationParameters.length > 0) {
            String[] paramArray = new String[this.operationParameters.length];
            System.arraycopy(this.operationParameters, 0, paramArray, 0, this.operationParameters.length);
            return paramArray;
        }
        return null;
    }

    public void setOperationParameters(String[] theParams) {
        String[] newParamArray = null;
        if (theParams != null && theParams.length > 0) {
            newParamArray = new String[theParams.length];
            System.arraycopy(theParams, 0, newParamArray, 0, theParams.length);
        }
        this.operationParameters = newParamArray;
    }

    public String getRequestedInterface() {
        return this.requestedInterface;
    }

    public void setRequestedInterface(String theInterface) {
        this.requestedInterface = theInterface;
    }

    public String[] getResponses() {
        return this.translateStrArray(this.responses);
    }

    public void setResponses(String[] theResponses) {
        String[] newResponses = null;
        if (theResponses != null) {
            newResponses = new String[theResponses.length];
            for (int i = 0; i < theResponses.length; ++i) {
                newResponses[i] = theResponses[i].trim();
            }
        }
        this.responses = newResponses;
    }

    public long getDeadline() {
        if (this.deadline == null) {
            return 0L;
        }
        try {
            return Long.parseLong(this.deadline);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    public void setDeadline(long theDeadline) throws VWException {
        if (theDeadline < 0L) {
            throw new VWException("vw.api.VWStepDefinitionNegativeDeadline", "Negative deadline value {0} not allowed", String.valueOf(theDeadline));
        }
        if (this.stepId == 0 && this.getMap() != null && this.getMap().mapId == VWMapDefinition.mapNameToId("Workflow")) {
            this.deadline = null;
            return;
        }
        this.deadline = String.valueOf(theDeadline);
    }

    public String getDeadlineExpr() throws VWException {
        return this.deadline;
    }

    public void setDeadlineExpr(String theDeadlineExpr) throws VWException {
        if (this.stepId == 0 && this.getMap() != null && this.getMap().mapId == VWMapDefinition.mapNameToId("Workflow")) {
            this.deadline = null;
            return;
        }
        this.deadline = theDeadlineExpr;
    }

    public String getDeadlineMap() {
        return this.translateStr(this.deadlineMap);
    }

    public void setDeadlineMap(String theDeadlineMap) {
        this.deadlineMap = theDeadlineMap;
    }

    public long getReminder() {
        return this.reminder;
    }

    public String getPostMilestone() {
        return this.translateStr(this.postMilestone);
    }

    public void setPostMilestone(String mileStoneName) throws VWException {
        this.postMilestone = mileStoneName == null ? null : mileStoneName;
    }

    public void setPreMilestone(String mileStoneName) throws VWException {
        this.preMilestone = mileStoneName == null ? null : mileStoneName;
    }

    public String getPreMilestone() {
        return this.translateStr(this.preMilestone);
    }

    public void setReminder(long theReminder) throws VWException {
        if (theReminder < 0L) {
            throw new VWException("vw.api.VWStepDefinitionNegativeReminder", "Negative reminder value {0} not allowed", String.valueOf(theReminder));
        }
        this.reminder = theReminder;
    }

    public String[][] getPreAssignments() {
        if (this.preAssignments != null && this.preAssignments.length > 0) {
            String[][] assignmentsArray = new String[this.preAssignments.length][2];
            for (int i = 0; i < this.preAssignments.length; ++i) {
                System.arraycopy(this.preAssignments[i], 0, assignmentsArray[i], 0, 2);
            }
            return assignmentsArray;
        }
        return null;
    }

    public void setPreAssignments(String[][] thePreAssignments) throws VWException {
        String[][] newAssignmentsArray = null;
        if (thePreAssignments != null && thePreAssignments.length > 0) {
            newAssignmentsArray = new String[thePreAssignments.length][2];
            for (int i = 0; i < thePreAssignments.length; ++i) {
                if (thePreAssignments[i].length != 2) {
                    throw new VWException("vw.api.VWStepDefinitionAssignmentArrayWrongDimension", "Assignment array wrong dimension, row {0} has {1} elements, should have 2 (representing the left and right values of the assignment)", String.valueOf(i), String.valueOf(thePreAssignments[i].length));
                }
                if (thePreAssignments[i][0] == null || thePreAssignments[i][1] == null) {
                    throw new VWException("vw.api.VWStepDefinitionAssignmentArrayNullElement", "Assignment array contains a null entry in row {0}", String.valueOf(i));
                }
                newAssignmentsArray[i] = new String[2];
                System.arraycopy(thePreAssignments[i], 0, newAssignmentsArray[i], 0, 2);
            }
        }
        this.preAssignments = newAssignmentsArray;
    }

    public String[][] getPostAssignments() {
        if (this.postAssignments != null && this.postAssignments.length > 0) {
            String[][] assignmentsArray = new String[this.postAssignments.length][2];
            for (int i = 0; i < this.postAssignments.length; ++i) {
                System.arraycopy(this.postAssignments[i], 0, assignmentsArray[i], 0, 2);
            }
            return assignmentsArray;
        }
        return null;
    }

    public void setPostAssignments(String[][] thePostAssignments) throws VWException {
        String[][] newAssignmentsArray = null;
        if (thePostAssignments != null && thePostAssignments.length > 0) {
            newAssignmentsArray = new String[thePostAssignments.length][2];
            for (int i = 0; i < thePostAssignments.length; ++i) {
                if (thePostAssignments[i].length != 2) {
                    throw new VWException("vw.api.VWStepDefinitionAssignmentArrayWrongDimension", "Assignment array wrong dimension, row {0} has {1} elements, should have 2 (representing the left and right values of the assignment)", String.valueOf(i), String.valueOf(thePostAssignments[i].length));
                }
                if (thePostAssignments[i][0] == null || thePostAssignments[i][1] == null) {
                    throw new VWException("vw.api.VWStepDefinitionAssignmentArrayNullElement", "Assignment array contains a null entry in row {0}", String.valueOf(i));
                }
                newAssignmentsArray[i] = new String[2];
                System.arraycopy(thePostAssignments[i], 0, newAssignmentsArray[i], 0, 2);
            }
        }
        this.postAssignments = newAssignmentsArray;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        int i;
        VWRouteDefinition[] r;
        int i2;
        VWParameterDefinition[] p;
        int i3;
        String ATTRIB_INDENT = "\t\t\t";
        if (theBuffer == null) {
            throw new VWException("vw.api.VWStepDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t\t<Step\n");
        theBuffer.append(ATTRIB_INDENT + "StepId=\"" + Integer.toString(this.getStepId()) + "\"\n");
        if (this.getName() != null) {
            theBuffer.append(ATTRIB_INDENT + "Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"\n");
        }
        if (this.getDescription() != null) {
            theBuffer.append(ATTRIB_INDENT + "Description=\"" + VWXMLHandler.toXMLString(this.getDescription()) + "\"\n");
        }
        if (this.getDocumentation() != null) {
            theBuffer.append(ATTRIB_INDENT + "Documentation=\"" + VWXMLHandler.toXMLString(this.getDocumentation()) + "\"\n");
        }
        if (this.getLocation() != null) {
            theBuffer.append(ATTRIB_INDENT + "XCoordinate=\"" + Integer.toString(this.getLocation().x) + "\"\n");
            theBuffer.append(ATTRIB_INDENT + "YCoordinate=\"" + Integer.toString(this.getLocation().y) + "\"\n");
        }
        if (this.requestedInterface != null) {
            theBuffer.append(ATTRIB_INDENT + "RequestedInterface=\"" + VWXMLHandler.toXMLString(this.requestedInterface) + "\"\n");
        }
        if (this.getAuthorTool() != null) {
            theBuffer.append(ATTRIB_INDENT + "AuthorTool=\"" + VWXMLHandler.toXMLString(this.getAuthorTool()) + "\"\n");
        }
        if (this.queueName != null) {
            theBuffer.append(ATTRIB_INDENT + "QueueName=\"" + VWXMLHandler.toXMLString(this.queueName) + "\"\n");
        }
        if (this.preMilestone != null) {
            theBuffer.append(ATTRIB_INDENT + "PreMilestone=\"" + VWXMLHandler.toXMLString(this.preMilestone) + "\"\n");
        }
        if (this.postMilestone != null) {
            theBuffer.append(ATTRIB_INDENT + "PostMilestone=\"" + VWXMLHandler.toXMLString(this.postMilestone) + "\"\n");
        }
        if (this.deadline != null) {
            theBuffer.append(ATTRIB_INDENT + "Deadline=\"" + VWXMLHandler.toXMLString(this.getDeadlineExpr()) + "\"\n");
        }
        if (this.deadlineMap != null) {
            theBuffer.append(ATTRIB_INDENT + "DeadlineMap=\"" + VWXMLHandler.toXMLString(this.getDeadlineMap()) + "\"\n");
        }
        if (this.reminder > 0L) {
            theBuffer.append(ATTRIB_INDENT + "Reminder=\"" + Long.toString(this.reminder) + "\"\n");
        }
        if (this.getJoinStepId() != -1) {
            theBuffer.append(ATTRIB_INDENT + "JoinStepId=\"" + Integer.toString(this.getJoinStepId()) + "\"\n");
        }
        theBuffer.append(ATTRIB_INDENT + "JoinType=\"" + VWJoinType.typeToString(this.getJoinType()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "SplitType=\"" + VWSplitType.typeToString(this.getSplitType()) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "CanReassign=\"" + VWXMLHandler.booleanToString(this.canReassign) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "CanViewStatus=\"" + VWXMLHandler.booleanToString(this.canViewStatus) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "CanViewHistory=\"" + VWXMLHandler.booleanToString(this.canViewHistory) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "IgnoreInvalidUsers=\"" + VWXMLHandler.booleanToString(this.ignoreInvalidUsers) + "\">\n");
        if (this.preAssignments != null) {
            theBuffer.append(ATTRIB_INDENT + "<PreAssignments>\n");
            for (i3 = 0; i3 < this.preAssignments.length; ++i3) {
                theBuffer.append(ATTRIB_INDENT + "<Assign LVal=\"" + VWXMLHandler.toXMLString(this.preAssignments[i3][0]) + "\" RVal=\"" + VWXMLHandler.toXMLString(this.preAssignments[i3][1]) + "\" />\n");
            }
            theBuffer.append(ATTRIB_INDENT + "</PreAssignments>\n");
        }
        if (this.participants != null) {
            for (i3 = 0; i3 < this.participants.length; ++i3) {
                theBuffer.append(ATTRIB_INDENT + "<Participant Val=\"" + VWXMLHandler.toXMLString(this.participants[i3].toString()) + "\" />\n");
            }
        }
        if (this.responses != null) {
            for (i3 = 0; i3 < this.responses.length; ++i3) {
                theBuffer.append(ATTRIB_INDENT + "<Response Val=\"" + VWXMLHandler.toXMLString(this.responses[i3]) + "\" />\n");
            }
        }
        if ((p = this.getParameterDefinitions()) != null) {
            for (i2 = 0; i2 < p.length; ++i2) {
                p[i2].toXML(theBuffer, ATTRIB_INDENT);
            }
        }
        if (this.operationName != null) {
            theBuffer.append(ATTRIB_INDENT + "<StepOperation Name=\"" + VWXMLHandler.toXMLString(this.operationName) + "\"");
            if (this.operationParameters != null) {
                theBuffer.append(">\n");
                for (i2 = 0; i2 < this.operationParameters.length; ++i2) {
                    theBuffer.append(ATTRIB_INDENT + "\t" + "<Expression Val=\"" + VWXMLHandler.toXMLString(this.operationParameters[i2]) + "\" />\n");
                }
                theBuffer.append(ATTRIB_INDENT + "</StepOperation>\n");
            } else {
                theBuffer.append("/>\n");
            }
        }
        if ((r = this.getNextRoutes()) != null) {
            for (int j = 0; j < r.length; ++j) {
                r[j].toXML(theBuffer);
            }
        }
        if (this.postAssignments != null) {
            theBuffer.append(ATTRIB_INDENT + "<PostAssignments>\n");
            for (i = 0; i < this.postAssignments.length; ++i) {
                theBuffer.append(ATTRIB_INDENT + "<Assign LVal=\"" + VWXMLHandler.toXMLString(this.postAssignments[i][0]) + "\" RVal=\"" + VWXMLHandler.toXMLString(this.postAssignments[i][1]) + "\" />\n");
            }
            theBuffer.append(ATTRIB_INDENT + "</PostAssignments>\n");
        }
        block17: for (i = 0; i < 3; ++i) {
            if (this.ruleSets[i] == null || this.ruleSets[i].length <= 0) continue;
            switch (i) {
                case 0: {
                    theBuffer.append(ATTRIB_INDENT + "<PreRule>\n");
                    break;
                }
                case 1: {
                    theBuffer.append(ATTRIB_INDENT + "<UpdateRule>\n");
                    break;
                }
                case 2: {
                    theBuffer.append(ATTRIB_INDENT + "<PostRule>\n");
                }
            }
            for (int j = 0; j < this.ruleSets[i].length; ++j) {
                theBuffer.append(ATTRIB_INDENT + "\t" + "<Expression Val=\"" + VWXMLHandler.toXMLString(this.ruleSets[i][j]) + "\" />\n");
            }
            switch (i) {
                case 0: {
                    theBuffer.append(ATTRIB_INDENT + "</PreRule>\n");
                    continue block17;
                }
                case 1: {
                    theBuffer.append(ATTRIB_INDENT + "</UpdateRule>\n");
                    continue block17;
                }
                case 2: {
                    theBuffer.append(ATTRIB_INDENT + "</PostRule>\n");
                }
            }
        }
        if (this.attributes != null) {
            this.attributes.toXML(theBuffer, ATTRIB_INDENT);
        }
        theBuffer.append("\t\t</Step>\n");
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        VWParameterDefinition[] parameters;
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        String indentD = VWXMLHandler.incXMLIndent(indentC);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWStepDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        VWWorkflowDefinition wfdef = this.getMap().getWorkflow();
        if (wfdef.getWorkflowCollection() == null) {
            throw new VWException("vw.api.VWStepDefinitionNullWorkflowCollection", "The XPDL string cannot be created for this step definition. The necessary reference to a containing workflow collection definition is null. \nEnsure that the workflow collection definition containing this step definition is specified.");
        }
        String idStr = "Workflow" + wfdef.getWorkflowCollection().getWorkflowIndex(wfdef.getName()) + ".Map" + wfdef.getMapIndex(this.getMap().getName()) + "." + VWAssociationTargetType.typeToString(1) + Integer.toString(this.getStepId());
        theBuffer.append(indentA + "<Activity Id=\"" + idStr + "\"");
        if (this.getName() != null) {
            theBuffer.append(" Name=\"" + VWXMLHandler.toXMLString(this.getName()) + "\"");
        }
        if (this.stepId == 0) {
            theBuffer.append(" StartActivity=\"true\"");
        }
        theBuffer.append(">\n");
        if (this.getDescription() != null) {
            theBuffer.append(indentB + "<Description>" + VWXMLHandler.toXMLString(this.getDescription()) + "</Description>\n");
        }
        if ((parameters = this.getParameterDefinitions()) != null) {
            String indentE = VWXMLHandler.incXMLIndent(indentD);
            String indentF = VWXMLHandler.incXMLIndent(indentE);
            theBuffer.append(indentB + "<Implementation>\n");
            theBuffer.append(indentC + "<Task>\n");
            theBuffer.append(indentD + "<TaskApplication Id=\"" + idStr + ".Parameters\">\n");
            theBuffer.append(indentE + "<DataMappings>\n");
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i].toXPDL(indentF, theBuffer);
            }
            theBuffer.append(indentE + "</DataMappings>\n");
            theBuffer.append(indentD + "</TaskApplication>\n");
            theBuffer.append(indentC + "</Task>\n");
            theBuffer.append(indentB + "</Implementation>\n");
        }
        if (this.participants != null) {
            theBuffer.append(indentB + "<Performers>\n");
            for (int i = 0; i < this.participants.length; ++i) {
                theBuffer.append(indentC + "<Performer>" + VWXMLHandler.toXMLString(this.participants[i].toString()) + "</Performer>\n");
            }
            theBuffer.append(indentB + "</Performers>\n");
        }
        if (this.deadline != null || this.deadlineMap != null) {
            theBuffer.append(indentB + "<Deadline Execution=\"SYNCHR\">\n");
            if (this.deadline != null) {
                long lDeadline = this.getDeadline();
                if (lDeadline != -1L) {
                    theBuffer.append(indentC + "<DeadlineDuration>" + VWXMLHandler.toXMLString(this.getDeadlineExpr()) + " Minutes</DeadlineDuration>\n");
                } else {
                    theBuffer.append(indentC + "<DeadlineDuration>" + VWXMLHandler.toXMLString(this.getDeadlineExpr()) + "</DeadlineDuration>\n");
                }
            }
            if (this.deadlineMap != null) {
                theBuffer.append(indentC + "<ExceptionName>" + VWXMLHandler.toXMLString(this.getDeadlineMap()) + "</ExceptionName>\n");
            }
            theBuffer.append(indentB + "</Deadline>\n");
        }
        if (this.getJoinType() != 3 || this.getSplitType() != 3) {
            theBuffer.append(indentB + "<TransitionRestrictions>\n");
            theBuffer.append(indentC + "<TransitionRestriction>\n");
            if (this.getJoinType() == 1) {
                theBuffer.append(indentD + "<Join Type=\"AND\"/>\n");
            } else if (this.getJoinType() == 2) {
                theBuffer.append(indentD + "<Join Type=\"XOR\"/>\n");
            }
            if (this.getSplitType() == 1) {
                theBuffer.append(indentD + "<Split Type=\"AND\"/>\n");
            } else if (this.getSplitType() == 2) {
                theBuffer.append(indentD + "<Split Type=\"XOR\"/>\n");
            }
            theBuffer.append(indentC + "</TransitionRestriction>\n");
            theBuffer.append(indentB + "</TransitionRestrictions>\n");
        }
        if (this.preAssignments != null && this.preAssignments.length > 0 || this.postAssignments != null && this.postAssignments.length > 0) {
            theBuffer.append(indentB + "<Assignments>\n");
            if (this.preAssignments != null) {
                for (int i = 0; i < this.preAssignments.length; ++i) {
                    theBuffer.append(indentC + "<Assignment AssignTime=\"Start\">\n");
                    theBuffer.append(indentD + "<Target>" + VWXMLHandler.toXMLString(this.preAssignments[i][0]) + "</Target>\n");
                    theBuffer.append(indentD + "<Expression>" + VWXMLHandler.toXMLString(this.preAssignments[i][1]) + "</Expression>\n");
                    theBuffer.append(indentC + "</Assignment>\n");
                }
            }
            if (this.postAssignments != null) {
                for (int i = 0; i < this.postAssignments.length; ++i) {
                    theBuffer.append(indentC + "<Assignment AssignTime=\"End\">\n");
                    theBuffer.append(indentD + "<Target>" + VWXMLHandler.toXMLString(this.postAssignments[i][0]) + "</Target>\n");
                    theBuffer.append(indentD + "<Expression>" + VWXMLHandler.toXMLString(this.postAssignments[i][1]) + "</Expression>\n");
                    theBuffer.append(indentC + "</Assignment>\n");
                }
            }
            theBuffer.append(indentB + "</Assignments>\n");
        }
        VWXPDL_20_parser.writeXPDLNodeGraphicsInfos(this.getLocation(), null, null, false, this.getOriginalNodeGraphicsInfosNode(), indentB, theBuffer);
        theBuffer.append(indentB + "<Extensions/>\n");
        theBuffer.append(indentB + "<fn:Step\n");
        if (this.getDocumentation() != null) {
            theBuffer.append(indentC + "Documentation=\"" + VWXMLHandler.toXMLString(this.getDocumentation()) + "\"\n");
        }
        if (this.requestedInterface != null) {
            theBuffer.append(indentC + "RequestedInterface=\"" + VWXMLHandler.toXMLString(this.requestedInterface) + "\"\n");
        }
        if (this.getAuthorTool() != null) {
            theBuffer.append(indentC + "AuthorTool=\"" + VWXMLHandler.toXMLString(this.getAuthorTool()) + "\"\n");
        }
        if (this.queueName != null) {
            theBuffer.append(indentC + "QueueName=\"" + VWXMLHandler.toXMLString(this.queueName) + "\"\n");
        }
        if (this.preMilestone != null) {
            theBuffer.append(indentC + "PreMilestone=\"" + VWXMLHandler.toXMLString(this.preMilestone) + "\"\n");
        }
        if (this.postMilestone != null) {
            theBuffer.append(indentC + "PostMilestone=\"" + VWXMLHandler.toXMLString(this.postMilestone) + "\"\n");
        }
        if (this.reminder > 0L) {
            theBuffer.append(indentC + "Reminder=\"" + Long.toString(this.reminder) + "\"\n");
        }
        theBuffer.append(indentC + "CanReassign=\"" + VWXMLHandler.booleanToString(this.canReassign) + "\"\n");
        theBuffer.append(indentC + "CanViewStatus=\"" + VWXMLHandler.booleanToString(this.canViewStatus) + "\"\n");
        theBuffer.append(indentC + "CanViewHistory=\"" + VWXMLHandler.booleanToString(this.canViewHistory) + "\"\n");
        theBuffer.append(indentC + "IgnoreInvalidUsers=\"" + VWXMLHandler.booleanToString(this.ignoreInvalidUsers) + "\">\n");
        if (this.responses != null) {
            for (int i = 0; i < this.responses.length; ++i) {
                theBuffer.append(indentC + "<Response Val=\"" + VWXMLHandler.toXMLString(this.responses[i]) + "\" />\n");
            }
        }
        if (this.operationName != null) {
            theBuffer.append(indentC + "<StepOperation Name=\"" + VWXMLHandler.toXMLString(this.operationName) + "\">\n");
            if (this.operationParameters != null) {
                for (int i = 0; i < this.operationParameters.length; ++i) {
                    theBuffer.append(indentD + "<Expression Val=\"" + VWXMLHandler.toXMLString(this.operationParameters[i]) + "\"/>\n");
                }
            }
            theBuffer.append(indentC + "</StepOperation>\n");
        }
        block16: for (int i = 0; i < 3; ++i) {
            if (this.ruleSets[i] == null || this.ruleSets[i].length <= 0) continue;
            switch (i) {
                case 0: {
                    theBuffer.append(indentC + "<PreRule>\n");
                    break;
                }
                case 1: {
                    theBuffer.append(indentC + "<UpdateRule>\n");
                    break;
                }
                case 2: {
                    theBuffer.append(indentC + "<PostRule>\n");
                }
            }
            for (int j = 0; j < this.ruleSets[i].length; ++j) {
                theBuffer.append(indentD + "<Expression Val=\"" + VWXMLHandler.toXMLString(this.ruleSets[i][j]) + "\" />\n");
            }
            switch (i) {
                case 0: {
                    theBuffer.append(indentC + "</PreRule>\n");
                    continue block16;
                }
                case 1: {
                    theBuffer.append(indentC + "</UpdateRule>\n");
                    continue block16;
                }
                case 2: {
                    theBuffer.append(indentC + "</PostRule>\n");
                }
            }
        }
        if (this.attributes != null) {
            this.attributes.toXML(theBuffer, indentC);
        }
        theBuffer.append(indentB + "</fn:Step>\n");
        theBuffer.append(indentA + "</Activity>\n");
    }

    public void validate(VWSession theSession, Vector EDefVector) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(theSession, EDefVector);
        this.validate(validationContext);
    }

    protected void validate(VWValidationContext validationContext) throws VWException {
        VWValidationError theError;
        VWString theMessage;
        String[][] a;
        VWParameterDefinition[] p;
        VWValidationError theError2;
        VWString theMessage2;
        VWValidationError theError3;
        VWString theMessage3;
        int i;
        VWWorkflowSignature myBaseWflSignature;
        VWWorkflowSignature myWflSignature;
        block87: {
            block86: {
                myWflSignature = this.getMap().getWorkflow().getWorkflowSignature(validationContext);
                myBaseWflSignature = this.getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
                if (this.deadline != null) {
                    try {
                        Long.parseLong(this.deadline);
                    }
                    catch (NumberFormatException e) {
                        VWCompiledExpr compRes = new VWCompiledExpr();
                        String[] theErrorStrings = VWExpr.compileVWExpr(this.deadline, myWflSignature, myBaseWflSignature, null, null, true, compRes);
                        if (theErrorStrings != null) {
                            int errorCount = theErrorStrings.length;
                            for (i = 0; i < errorCount; ++i) {
                                theMessage3 = new VWString("vw.api.VWStepDefinitionDeadlineSyntaxError", "Syntax error in deadline expression : {0}", theErrorStrings[i]);
                                theError3 = new VWValidationError(1, 1, this.name, this.deadline, theMessage3.toString(), this.getMap().getName(), this.getStepId());
                                validationContext.addValidationError(theError3);
                            }
                        }
                        if (!compRes.getResultIsArray() && compRes.getResultType() == 16) break block86;
                        VWString theMessage4 = new VWString("vw.api.VWStepDefinitionErrorInDeadlineTimeExpr", "deadline must be a time expression and it cannot be an array.");
                        VWValidationError theError4 = new VWValidationError(1, 1, this.deadline, null, theMessage4.toString(), this.getMap().getName(), this.getStepId());
                        validationContext.addValidationError(theError4);
                    }
                }
            }
            if (this.deadline == null && this.deadlineMap != null) {
                theMessage2 = new VWString("vw.api.VWStepDefinitionDeadlineMapButNoDeadline", "The step contains a deadline map, but no deadline expiration has been specified.");
                theError2 = new VWValidationError(1, 2, this.name, this.deadlineMap, theMessage2.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError2);
            }
            if (this.deadlineMap != null && VWMapDefinition.mapNameToId(this.deadlineMap) == 0) {
                try {
                    this.getMap().getWorkflow().getMap(this.deadlineMap);
                }
                catch (Exception e) {
                    if (myBaseWflSignature != null && myBaseWflSignature.isInstructionSheetName(this.deadlineMap)) break block87;
                    VWString theMessage5 = new VWString("vw.api.VWWorkflowDefinitionDeadlineMapNotFound", "The map to be called on workflow deadline expiration, {0}, was not found in this or the parent workflow definition.", this.deadlineMap);
                    VWValidationError theError5 = new VWValidationError(1, 1, this.name, this.deadlineMap, theMessage5.toString(), this.getMap().getName(), this.getStepId());
                    validationContext.addValidationError(theError5);
                }
            }
        }
        if (this.reminder > 0L) {
            // empty if block
        }
        if (this.requestedInterface != null) {
            if (this.requestedInterface.length() == 0) {
                theMessage2 = new VWString("vw.api.VWStepDefinitionEmptyRequestedInterface", "The Requested Interface value for the step is an empty string.");
                theError2 = new VWValidationError(1, 1, this.getName(), null, theMessage2.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError2);
            } else {
                int stepProcId = -1;
                boolean errorParsingInt = false;
                boolean foundStepProc = false;
                try {
                    stepProcId = Integer.parseInt(this.requestedInterface);
                }
                catch (Exception e) {
                    errorParsingInt = true;
                }
                VWStepProcessorInfoDefinition[] stepProcs = validationContext.getStepProcessorDefinitions();
                if (stepProcs != null) {
                    if (!errorParsingInt) {
                        for (i = 0; i < stepProcs.length; ++i) {
                            if (stepProcs[i].getId() != stepProcId) continue;
                            foundStepProc = true;
                            break;
                        }
                    } else {
                        for (i = 0; i < stepProcs.length; ++i) {
                            if (!stepProcs[i].getName().equals(this.requestedInterface)) continue;
                            foundStepProc = true;
                            break;
                        }
                    }
                    if (!foundStepProc) {
                        VWString theMessage6 = new VWString("vw.api.VWStepDefinitionInvalidRequestedInterface", "The Requested Interface value, {0}, is invalid, no such step processor definition exists on the server.", this.requestedInterface);
                        VWValidationError theError6 = new VWValidationError(1, 1, this.getName(), null, theMessage6.toString(), this.getMap().getName(), this.getStepId());
                        validationContext.addValidationError(theError6);
                    }
                }
            }
        } else if (this.queueName != null && this.queueName.length() > 0) {
            theMessage2 = new VWString("vw.api.VWStepDefinitionNoRequestedInterface", "A step with a queue assigned to it should have a valid requested interface.");
            theError2 = new VWValidationError(1, 2, this.getName(), null, theMessage2.toString(), this.getMap().getName(), this.getStepId());
            validationContext.addValidationError(theError2);
        }
        if (this.queueName != null) {
            VWQueueDefinition theQueueDef = null;
            try {
                theQueueDef = validationContext.getQueueDefinition(this.queueName);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (theQueueDef == null) {
                VWString theMessage7 = new VWString("vw.api.VWStepDefinitionQueueNotFound", "Either the queue, {0}, does not exist, or it is not valid for this logon session.  Select a different queue, or use the configuration tool to create the queue, or give the user permission to use the queue.", this.queueName);
                VWValidationError theError7 = new VWValidationError(1, 1, this.getName(), this.queueName, theMessage7.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError7);
            } else if (theQueueDef.getQueueType() == 2) {
                if (this.participants == null || this.participants.length == 0) {
                    VWString theMessage8 = new VWString("vw.api.VWStepDefinitionNoParticipant", "The step refers to the user-centric queue \"{0}\" and needs to have at least ONE participant.", this.queueName);
                    VWValidationError theError8 = new VWValidationError(1, 1, this.getName(), this.queueName, theMessage8.toString(), this.getMap().getName(), this.getStepId());
                    validationContext.addValidationError(theError8);
                }
            } else if (this.participants != null || this.participants != null && this.participants.length != 0) {
                VWString theMessage9 = new VWString("vw.api.VWStepDefinitionRemoveParticipants", "The step does not refer to a user-centric queue (\"{0}\") and must not have any participants assigned to it.", this.queueName);
                VWValidationError theError9 = new VWValidationError(1, 1, this.getName(), this.queueName, theMessage9.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError9);
            }
        }
        if (this.operationName != null && (this.queueName == null || this.queueName.length() == 0)) {
            VWString theMessage10 = new VWString("vw.api.VWStepDefinitionHasOperationButNoQueue", "The step contains an operation name (\"{0}\") but no queue name.", this.operationName);
            VWValidationError theError10 = new VWValidationError(1, 1, this.getName(), this.operationName, theMessage10.toString(), this.getMap().getName(), this.getStepId());
            validationContext.addValidationError(theError10);
        }
        if (this.operationName != null && this.queueName != null) {
            VWQueueDefinition theQueueDef = null;
            VWOperationDefinition theOpDef = null;
            VWParameterDefinition[] theParamDefs = null;
            try {
                theQueueDef = validationContext.getQueueDefinition(this.queueName);
                theOpDef = theQueueDef.getOperation(this.operationName);
                theParamDefs = theOpDef.getParameterDefinitions();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (theOpDef == null) {
                VWString theMessage11 = new VWString("vw.api.VWStepDefinitionOperationNotFound", "The step uses an operation {0}.{1} which is not defined on the server.", this.queueName, this.operationName);
                VWValidationError theError11 = new VWValidationError(1, 1, this.getName(), this.queueName, theMessage11.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError11);
            }
            if (this.operationParameters == null && theParamDefs != null && theParamDefs.length != 0) {
                VWString theMessage12 = new VWString("vw.api.VWStepDefinitionMissingOperationParameters", "The step has no operation parameter values, but the operation {0}.{1} is defined to require {2} parameter(s).", this.queueName, this.operationName, String.valueOf(theParamDefs.length));
                VWValidationError theError12 = new VWValidationError(1, 1, this.getName(), this.queueName, theMessage12.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError12);
            }
            if (this.operationParameters != null && this.operationParameters.length != 0 && theOpDef != null && (theParamDefs == null || theParamDefs.length == 0)) {
                VWString theMessage13 = new VWString("vw.api.VWStepDefinitionMissingOperationParameters", "The step has operation parameter values, but the operation {0}.{1} is defined to require no parameters.", this.queueName, this.operationName);
                VWValidationError theError13 = new VWValidationError(1, 1, this.getName(), this.queueName, theMessage13.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError13);
            }
            if (theQueueDef != null && theOpDef != null && this.operationParameters != null) {
                if (theParamDefs != null && this.operationParameters.length != theParamDefs.length) {
                    VWString theMessage14 = new VWString("vw.api.VWStepDefinitionWrongOperationParameterCount", "The step has {0} operation parameter(s), but the operation {1} is defined to require {2} parameters.", String.valueOf(this.operationParameters.length), this.queueName + "." + this.operationName, String.valueOf(theParamDefs.length));
                    VWValidationError theError14 = new VWValidationError(1, 1, this.getName(), this.queueName, theMessage14.toString(), this.getMap().getName(), this.getStepId());
                    validationContext.addValidationError(theError14);
                }
                for (int i2 = 0; i2 < this.operationParameters.length; ++i2) {
                    String sParamName = "";
                    if (theParamDefs != null && theParamDefs[i2] != null) {
                        sParamName = theParamDefs[i2].getName();
                    }
                    if (sParamName == null) {
                        sParamName = "";
                    }
                    if (this.operationParameters[i2] == null || this.operationParameters[i2].compareTo("") == 0) {
                        theMessage3 = new VWString("vw.api.VWStepDefinitionOpParamIsNull", "Step operation parameter {0} is null or empty", sParamName);
                        theError3 = new VWValidationError(1, 1, this.getName(), sParamName, theMessage3.toString(), this.getMap().getName(), this.getStepId());
                        validationContext.addValidationError(theError3);
                        continue;
                    }
                    if (theParamDefs == null || theParamDefs.length != this.operationParameters.length) continue;
                    VWCompiledExpr compRes = null;
                    String[] theErrorStrings = null;
                    if (theParamDefs[i2].getMode() == 3 || theParamDefs[i2].getMode() == 2) {
                        compRes = new VWCompiledRefExpr();
                        theErrorStrings = VWExpr.compileVWExpr(":=" + this.operationParameters[i2], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                    } else {
                        compRes = new VWCompiledExpr();
                        theErrorStrings = VWExpr.compileVWExpr(this.operationParameters[i2], myWflSignature, myBaseWflSignature, null, null, true, compRes);
                    }
                    if (theErrorStrings != null) {
                        int errorCount = theErrorStrings.length;
                        for (int j = 0; j < errorCount; ++j) {
                            VWString theMessage15 = new VWString("vw.api.VWStepDefinitionOpParamSyntaxError", "Step operation parameter [{0}] syntax error: {1}", sParamName, theErrorStrings[j]);
                            VWValidationError theError15 = new VWValidationError(1, 1, this.getName(), sParamName, theMessage15.toString(), this.getMap().getName(), this.getStepId());
                            validationContext.addValidationError(theError15);
                        }
                    } else if (theParamDefs[i2].getIsArray() != compRes.getResultIsArray()) {
                        VWString theMessage16 = new VWString("vw.api.VWStepDefinitionOpParamArrayTypeMismatch", "Step operation parameter [{0}], whose value is ({1}), Array v. non-array mismatch", sParamName, this.operationParameters[i2]);
                        VWValidationError theError16 = new VWValidationError(1, 1, this.getName(), sParamName, theMessage16.toString(), this.getMap().getName(), this.getStepId());
                        validationContext.addValidationError(theError16);
                    }
                    if (!VWFieldType.isValid(compRes.getResultType()) || !VWFieldType.isValid(theParamDefs[i2].getDataType()) || VWFieldType.isCompatibleType(theParamDefs[i2].getDataType(), compRes.getResultType())) continue;
                    VWString theMessage17 = new VWString("vw.api.VWStepDefinitionOpParamIncompatibleExpressionType", "Step operation parameter [{0}], value type found {1}, expected {2}", sParamName, VWFieldType.typeToString(compRes.getResultType()), VWFieldType.typeToString(theParamDefs[i2].getDataType()));
                    VWValidationError theError17 = new VWValidationError(1, 1, this.getName(), sParamName, theMessage17.toString(), this.getMap().getName(), this.getStepId());
                    validationContext.addValidationError(theError17);
                }
            }
        }
        if (this.operationParameters != null && (this.operationName == null || this.queueName == null)) {
            VWString theMessage18 = new VWString("vw.api.VWStepDefinitionOpParamNoOperation", "Step has operation parameters but either the operation name or queue name is null");
            VWValidationError theError18 = new VWValidationError(1, 2, this.getName(), null, theMessage18.toString(), this.getMap().getName(), this.getStepId());
            validationContext.addValidationError(theError18);
        }
        if ((p = this.getParameterDefinitions()) != null) {
            if (this.operationName == null) {
                for (int i3 = 0; i3 < p.length; ++i3) {
                    p[i3].validate(validationContext);
                }
            } else {
                VWString theMessage19 = new VWString("vw.api.VWStepDefinitionParamsAndOperationIllegal", "The step contains both parameter definitions and a reference to an operation (\"{0}.{1}\")", this.queueName, this.operationName);
                VWValidationError theError19 = new VWValidationError(1, 1, this.getName(), this.queueName, theMessage19.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError19);
            }
        }
        if ((a = this.getPreAssignments()) != null) {
            for (int i4 = 0; i4 < a.length; ++i4) {
                VWCompiledRefExpr lCompRes = new VWCompiledRefExpr();
                String[] theErrorStrings = VWExpr.compileVWExpr(":=" + a[i4][0], myWflSignature, myBaseWflSignature, null, null, true, lCompRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int k = 0; k < errorCount; ++k) {
                        VWString theMessage20 = new VWString("vw.api.VWStepDefinitionPreAsgnBadLValue", "Step pre-Assignment[{0}], the Left side of assignment, {1}, is not a valid LValue, Syntax Error {2}", String.valueOf(i4), a[i4][0], theErrorStrings[k]);
                        VWValidationError theError20 = new VWValidationError(1, 1, this.getName(), a[i4][0], theMessage20.toString(), this.getMap().getName(), this.getStepId());
                        validationContext.addValidationError(theError20);
                    }
                    continue;
                }
                int expectedRValueType = lCompRes.getResultType();
                boolean expectedRValueIsArray = lCompRes.getResultIsArray();
                VWCompiledExpr rCompRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(a[i4][1], myWflSignature, myBaseWflSignature, null, null, true, rCompRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int j = 0; j < errorCount; ++j) {
                        theMessage = new VWString("vw.api.VWStepDefinitionPreAsgnRValSyntaxError", "Step Pre-Assignment[{0}], RValue (expected type is {1}), syntax error: {2}", String.valueOf(i4), VWFieldType.typeToString(expectedRValueType) + (expectedRValueIsArray ? " array " : ""), theErrorStrings[j]);
                        theError = new VWValidationError(1, 1, this.getName(), a[i4][0], theMessage.toString(), this.getMap().getName(), this.getStepId());
                        validationContext.addValidationError(theError);
                    }
                    continue;
                }
                if (VWFieldType.isCompatibleType(lCompRes.getResultType(), rCompRes.getResultType()) && lCompRes.getResultIsArray() == rCompRes.getResultIsArray()) continue;
                VWString theMessage21 = new VWString("VWStepDefinitionPreAsgnTypeMismatch", "Step Pre-Assignment[{0}],  Incompatible type, expected {1}, found {2}.", String.valueOf(i4), VWFieldType.typeToString(lCompRes.getResultType()) + (lCompRes.getResultIsArray() ? "[ ]" : ""), VWFieldType.typeToString(rCompRes.getResultType()) + (rCompRes.getResultIsArray() ? "[ ]" : ""));
                VWValidationError theError21 = new VWValidationError(1, 1, this.getName(), a[i4][0], theMessage21.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError21);
            }
        }
        if ((a = this.getPostAssignments()) != null) {
            for (int i5 = 0; i5 < a.length; ++i5) {
                VWCompiledRefExpr lCompRes = new VWCompiledRefExpr();
                String[] theErrorStrings = VWExpr.compileVWExpr(":=" + a[i5][0], myWflSignature, myBaseWflSignature, null, null, true, lCompRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int k = 0; k < errorCount; ++k) {
                        VWString theMessage22 = new VWString("vw.api.VWStepDefinitionPostAsgnBadLValue", "Step post-Assignment[{0}], the Left side of assignment, {1}, is not a valid LValue, Syntax Error {2}", String.valueOf(i5), a[i5][0], theErrorStrings[k]);
                        VWValidationError theError22 = new VWValidationError(1, 1, this.getName(), a[i5][0], theMessage22.toString(), this.getMap().getName(), this.getStepId());
                        validationContext.addValidationError(theError22);
                    }
                    continue;
                }
                int expectedRValueType = lCompRes.getResultType();
                boolean expectedRValueIsArray = lCompRes.getResultIsArray();
                VWCompiledExpr rCompRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(a[i5][1], myWflSignature, myBaseWflSignature, null, null, true, rCompRes);
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int j = 0; j < errorCount; ++j) {
                        theMessage = new VWString("vw.api.VWStepDefinitionPostAsgnRValSyntaxError", "Step Post-Assignment[{0}], RValue (expected type is {1}), syntax error: {2}", String.valueOf(i5), VWFieldType.typeToString(expectedRValueType) + (expectedRValueIsArray ? " array " : ""), theErrorStrings[j]);
                        theError = new VWValidationError(1, 1, this.getName(), a[i5][0], theMessage.toString(), this.getMap().getName(), this.getStepId());
                        validationContext.addValidationError(theError);
                    }
                    continue;
                }
                if (VWFieldType.isCompatibleType(lCompRes.getResultType(), rCompRes.getResultType()) && lCompRes.getResultIsArray() == rCompRes.getResultIsArray()) continue;
                VWString theMessage23 = new VWString("VWStepDefinitionPostAsgnTypeMismatch", "Step Post-Assignment[{0}],  Incompatible type, expected {1}, found {2}.", String.valueOf(i5), VWFieldType.typeToString(lCompRes.getResultType()) + (lCompRes.getResultIsArray() ? "[ ]" : ""), VWFieldType.typeToString(rCompRes.getResultType()) + (rCompRes.getResultIsArray() ? "[ ]" : ""));
                VWValidationError theError23 = new VWValidationError(1, 1, this.getName(), a[i5][0], theMessage23.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError23);
            }
        }
        if (!(this.preMilestone == null || this.getMap().getWorkflow().isExistingMilestoneName(this.preMilestone) || myBaseWflSignature != null && myBaseWflSignature.isMilestoneName(this.preMilestone))) {
            VWString theMessage24 = new VWString("vw.api.VWStepDefinitionPreMilestoneNonExist", "The step pre-milestone refers to a non-existent milestone (\"{0}\").", this.preMilestone);
            VWValidationError theError24 = new VWValidationError(1, 1, this.getName(), this.preMilestone, theMessage24.toString(), this.getMap().getName(), this.getStepId());
            validationContext.addValidationError(theError24);
        }
        if (!(this.postMilestone == null || this.getMap().getWorkflow().isExistingMilestoneName(this.postMilestone) || myBaseWflSignature != null && myBaseWflSignature.isMilestoneName(this.postMilestone))) {
            VWString theMessage25 = new VWString("vw.api.VWStepDefinitionPostMilestoneNonExist", "The step post-milestone refers to a non-existent milestone (\"{0}\").", this.postMilestone);
            VWValidationError theError25 = new VWValidationError(1, 1, this.getName(), this.postMilestone, theMessage25.toString(), this.getMap().getName(), this.getStepId());
            validationContext.addValidationError(theError25);
        }
        if (this.responses != null && this.responses.length > 0) {
            if (!(super.getNodeType() == 1 || this.participants != null && this.participants.length != 0 || this.queueName != null && this.queueName.length() != 0)) {
                VWString theMessage26 = new VWString("vw.api.VWStepDefinitionDummyNoResponses", "A step with no queue and no participants assigned to it cannot contain responses.");
                VWValidationError theError26 = new VWValidationError(1, 1, this.getName(), null, theMessage26.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError26);
            }
            for (int i6 = 0; i6 < this.responses.length; ++i6) {
                if (this.responses[i6] != null && this.responses[i6].length() != 0) continue;
                VWString theMessage27 = new VWString("vw.api.VWStepDefinitionEmptyResponse", "A response should not be an empty string.");
                VWValidationError theError27 = new VWValidationError(1, 2, this.getName(), null, theMessage27.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError27);
            }
        }
        if (this.participants != null && this.participants.length > 0) {
            if (this.queueName == null || this.queueName.length() == 0) {
                VWString theMessage28 = new VWString("vw.api.VWStepDefinitionParticipantsNoQueue", "The step contains participants but the queue name is not defined.");
                VWValidationError theError28 = new VWValidationError(1, 1, this.getName(), "", theMessage28.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError28);
            }
            for (int i7 = 0; i7 < this.participants.length; ++i7) {
                VWCompiledExpr compRes;
                String parName = this.participants[i7].getParticipantName().trim();
                String[] theErrorStrings = VWExpr.compileVWExpr(parName, myWflSignature, myBaseWflSignature, null, null, true, compRes = new VWCompiledExpr());
                if (theErrorStrings != null) {
                    int errorCount = theErrorStrings.length;
                    for (int j = 0; j < errorCount; ++j) {
                        VWString theMessage29 = new VWString("vw.api.VWStepDefinitionParticipantSyntaxError", "Participant, {0}, syntax error: {1}", parName, theErrorStrings[j]);
                        VWValidationError theError29 = new VWValidationError(1, 1, this.getName(), parName, theMessage29.toString(), this.getMap().getName(), this.getStepId());
                        validationContext.addValidationError(theError29);
                    }
                    continue;
                }
                if (VWFieldType.isCompatibleType(64, compRes.getResultType()) || compRes.getResultType() == 1) continue;
                VWString theMessage30 = new VWString("vw.api.VWStepDefinitionBadParticipantField", "Participant {0} is not a valid participant, it may be a field of the wrong type.", parName);
                VWValidationError theError30 = new VWValidationError(1, 1, this.getName(), parName, theMessage30.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError30);
            }
        }
        if (!(this.participants != null && this.participants.length != 0 || this.queueName != null && this.queueName.length() != 0 || this.getRuleSets(1) == null)) {
            VWString theMessage31 = new VWString("vw.api.VWStepDefinitionDummyStepNoSaveRule", "A Dummy step, (no participant or queue), should not have any save rules.");
            VWValidationError theError31 = new VWValidationError(1, 2, this.getName(), null, theMessage31.toString(), this.getMap().getName(), this.getStepId());
            validationContext.addValidationError(theError31);
        }
        boolean noInvalidRules = true;
        for (int i8 = 0; i8 < 3; ++i8) {
            if (this.ruleSets[i8] == null || this.ruleSets[i8].length <= 0) continue;
            for (int j = 0; j < this.ruleSets[i8].length; ++j) {
                if (this.getMap().getWorkflow().isExistingRuleSet(this.ruleSets[i8][j]) || myBaseWflSignature != null && myBaseWflSignature.isRulesetName(this.ruleSets[i8][j])) continue;
                VWString theMessage32 = new VWString("vw.api.VWStepDefinitionRuleSetNotExist", "The step rule refers to a non-existent ruleset (\"{0}\").", this.ruleSets[i8][j]);
                VWValidationError theError32 = new VWValidationError(1, 1, this.getName(), this.ruleSets[i8][j], theMessage32.toString(), this.getMap().getName(), this.getStepId());
                validationContext.addValidationError(theError32);
                noInvalidRules = false;
            }
        }
        if (noInvalidRules) {
            boolean bFoundExpensiveSaveRule = false;
            String[] saveRuleArr = this.getRuleSetNames(1);
            VWWorkflowDefinition baseWFDef = null;
            if (saveRuleArr != null) {
                for (int i9 = 0; i9 < saveRuleArr.length; ++i9) {
                    if (this.getMap().getWorkflow().isExistingRuleSet(saveRuleArr[i9])) {
                        if (!this.getMap().getWorkflow().getRuleSetByName(saveRuleArr[i9]).getExpensive()) continue;
                        VWString theMessage33 = new VWString("vw.api.VWStepDefinitionExpensiveSaveRule", "The on save rules for the step contain at least one asynchronous rule, {0}.  When asynchronous rules are executed, locked work items will be unlocked, this can cause unexpected behavior in some applications.  Please see documentation for more details.", saveRuleArr[i9]);
                        VWValidationError theError33 = new VWValidationError(1, 2, this.getName(), saveRuleArr[i9], theMessage33.toString(), this.getMap().getName(), this.getStepId());
                        validationContext.addValidationError(theError33);
                        bFoundExpensiveSaveRule = true;
                        break;
                    }
                    if (myBaseWflSignature == null || !myBaseWflSignature.isRulesetName(saveRuleArr[i9])) continue;
                    if (baseWFDef == null) {
                        baseWFDef = this.getMap().getWorkflow().getBaseWorkflowDefinition(validationContext);
                    }
                    if (baseWFDef == null || !baseWFDef.getRuleSetByName(saveRuleArr[i9]).getExpensive()) continue;
                    VWString theMessage34 = new VWString("vw.api.VWStepDefinitionInheritedExpensiveSaveRule", "The on save rules for the step contain at least one inherited asynchronous rule, {0}.  When asynchronous rules are executed, locked work items will be unlocked, this can cause unexpected behavior in some applications.  Please see documentation for more details.", saveRuleArr[i9]);
                    VWValidationError theError34 = new VWValidationError(1, 2, this.getName(), saveRuleArr[i9], theMessage34.toString(), this.getMap().getName(), this.getStepId());
                    validationContext.addValidationError(theError34);
                    bFoundExpensiveSaveRule = true;
                    break;
                }
            }
        }
    }

    protected Object clone() {
        VWStepDefinition stepDef = (VWStepDefinition)super.clone();
        stepDef.setOperationParameters(this.operationParameters);
        stepDef.setParticipants(this.participants);
        stepDef.setResponses(this.responses);
        if (this.parameters != null) {
            stepDef.parameters = (VWParameterDefinition[])this.parameters.clone();
            for (int i = 0; i < this.parameters.length; ++i) {
                if (this.parameters[i] == null) continue;
                stepDef.parameters[i] = (VWParameterDefinition)this.parameters[i].clone();
                stepDef.parameters[i].myContainer = stepDef;
            }
        }
        if (this.parametersHandler != null) {
            stepDef.parametersHandler = (VWArrayHandler)this.parametersHandler.clone();
        }
        try {
            stepDef.setPreAssignments(this.preAssignments);
            stepDef.setPostAssignments(this.postAssignments);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stepDef;
    }
}

